#=------------------------------------------------------------------------------
    Auxiliary functions

    Weak approximation of SDEs in Julia

    Version of March 9, 2021

    Uses Julia 1.5.2
=#
#=------------------------------------------------------------------------------
    Euler_Maruyama integrator
=#
function Euler_Maruyama(X0::Array{Float64,1},h::Float64,N::Int64)
#=
    Author: Adrien Laurent
    Computes an approximation of the solution at time tN=h*N of the SDE using the Euler-Maruyama method.
    Input:
        X0 initial data
        h time stepsize
        N number of iterations
    Output:
        XN approximation of the solution at time tN=h*N with initial data X0
=#
    XN=X0
    for n in 1:N
        XN=XN+sigma*sqrt(h)*randn(length(X0))+h*f(XN)
    end
    return XN
end
