%% Intro

close all; clear;
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

format long

%% Reading data

T=1;
sigma=sqrt(2);
liste_N = floor(2.^(2:1/2:9))*T;
liste_h = T./liste_N;

S_num=importdata('./results/data.txt');
N_proc=size(S_num,1);

Weak_approx=zeros(1,length(liste_N));
for i=1:N_proc
    Weak_approx=Weak_approx+S_num(i,:);
end

exact_value=Weak_approx(1,end)/N_proc;
num_error=abs(Weak_approx(1,1:length(liste_N)-1)/N_proc-exact_value);

%% Plot

figure()

hold on
box on

xaxis_list=liste_h(1:length(liste_N)-1);

plot(xaxis_list,num_error(1,:),'-*','Color',[0.8500,0.3250,0.0980],'LineWidth',1.5,'MarkerSize',8);
plot(xaxis_list,xaxis_list*2,'--k','LineWidth',1.5)

axis([min(xaxis_list) max(xaxis_list) 1e-3 1e0])
set(gca, 'XScale', 'log', 'YScale','log')
grid off
hold off
xlabel('Stepsize $h$');
ylabel('Weak error');
legend({'Euler int.','Slope 1'},'Location','southeast');
