#=------------------------------------------------------------------------------
    Script for the cluster

    Weak approximation of SDEs in Julia

    Version of March 9, 2021

    Uses Julia 1.5.2
=#
#=------------------------------------------------------------------------------
    SDE parameters
=#
V0 = x -> norm(x)^2/2
f = x -> -x    # f=-DV0

sigma=sqrt(2)

# Test function
phi = x -> norm(x)^2
#=------------------------------------------------------------------------------
    Numerical parameters of the problem
=#
T=1
liste_N = [floor(Int,2^x) for x in (2:1/2:9)]*T
lN=length(liste_N)

X0=[0.;0.]

N_trajectories=100000
#=------------------------------------------------------------------------------
     Functions
=#
using Random
using DelimitedFiles
using LinearAlgebra

include("Functions.jl")
#=------------------------------------------------------------------------------
     Initialize random number generator
=#
if length(ARGS)==0
    Random.seed!(0)
else
    Random.seed!(parse(Int64,ARGS[1]))
end
#=------------------------------------------------------------------------------
     Main Script
=#
totaltime=time()
Snum=zeros(1,lN)
for p in 1:lN
    N=liste_N[p]
    h=T/N
    println("p=",p)
    start = time()
    for m in 1:N_trajectories
        Snum[p]+=phi(Euler_Maruyama(X0,h,N))
    end
    println(time() - start)
end
Snum=Snum/N_trajectories
println("total time = ",time()-totaltime)
#=------------------------------------------------------------------------------
     Storing results
=#
if length(ARGS)==0
    writedlm("./results/data.txt", Snum)
else
    writedlm(string("./results/res_",ARGS[1],".txt"), Snum)
end

println("end")
