%% Intro

close all; clear;
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

format long

%% Reading data

List_parameters=importdata('./Data/List_parameters.txt');
Lx=List_parameters(1);
N_FFT_x=round(List_parameters(2));
K_FFT_x=round(List_parameters(3));
K_FFT=round(List_parameters(6));
epsilon=List_parameters(7);
N=round(List_parameters(8));
Mmax=round(List_parameters(9));

u0_Fourier=importdata('./Data/u0_Fourier_re.txt')+1i*importdata('./Data/u0_Fourier_im.txt');

U_Fourier_1=importdata('./Data/Int1_re.txt')+1i*importdata('./Data/Int1_im.txt');
U_Fourier_2=importdata('./Data/Int2_re.txt')+1i*importdata('./Data/Int2_im.txt');
U_Fourier_1G=importdata('./Data/Int1G_re.txt')+1i*importdata('./Data/Int1G_im.txt');
U_Fourier_2G=importdata('./Data/Int2G_re.txt')+1i*importdata('./Data/Int2G_im.txt');

%% Grid evaluation

J=300;
xj=Lx/J*(-J:J)';

U_num1=zeros(2*J+1,Mmax+1);
U_num2=zeros(2*J+1,Mmax+1);
% U_num1G=zeros(2*J+1,Mmax+1);
U_num2G=zeros(2*J+1,Mmax+1);
U_der_num1=zeros(2*J+1,Mmax+1);
U_der_num2=zeros(2*J+1,Mmax+1);
% U_der_num1G=zeros(2*J+1,Mmax+1);
U_der_num2G=zeros(2*J+1,Mmax+1);
for m=1:Mmax+1
%     U_num1(:,m)=Grid_evaluation(U_Fourier_1(:,m),J,N_FFT_x,xj);
%     U_num2(:,m)=Grid_evaluation(U_Fourier_2(:,m),J,N_FFT_x,xj);
%    U_num1G(:,m)=Grid_evaluation(U_Fourier_1G(:,m),J,N_FFT_x,xj);
    U_num2G(:,m)=Grid_evaluation(U_Fourier_2G(:,m),J,N_FFT_x,xj);
    
%     U_der_num1(:,m)=Grid_evaluation_derivative(U_Fourier_1(:,m),J,N_FFT_x,xj);
%     U_der_num2(:,m)=Grid_evaluation_derivative(U_Fourier_2(:,m),J,N_FFT_x,xj);
%    U_der_num1G(:,m)=Grid_evaluation_derivative(U_Fourier_1G(:,m),J,N_FFT_x,xj);
    U_der_num2G(:,m)=Grid_evaluation_derivative(U_Fourier_2G(:,m),J,N_FFT_x,xj);
end

%% Animation

sol=U_num2G;
Dsol=U_der_num2G;

steps=1:Mmax+1;
for z=1:length(steps)
    subplot(2,2,1)
    grid on
	plot(xj,real(round(sol(:,steps(z)),15)),'LineWidth',1.5);
	axis([-Lx Lx -1.2 1.2])
	xlabel('$x$','FontSize',14);
    ylabel('$Re(u)$','FontSize',14);
    
    subplot(2,2,2)
    grid on
	plot(xj,imag(round(sol(:,steps(z)),15)),'LineWidth',1.5);
	axis([-Lx Lx -1.2 1.2])
	xlabel('$x$','FontSize',14);
    ylabel('$Im(u)$','FontSize',14);
    
    subplot(2,2,3)
    grid on
	plot(xj,real(round(Dsol(:,steps(z)),15)),'LineWidth',1.5);
	axis([-Lx Lx -15 15])
	xlabel('$x$','FontSize',14);
    ylabel('$Re(Du)$','FontSize',14);
    
    subplot(2,2,4)
    grid on
	plot(xj,imag(round(Dsol(:,steps(z)),15)),'LineWidth',1.5);
	axis([-Lx Lx -15 15])
	xlabel('$x$','FontSize',14);
    ylabel('$Im(Du)$','FontSize',14);
    
    pause(0.01)
    if (z==1)
        pause
    end
end

