%% Intro

close all; clear;
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

format long

%% Reading data

List_parameters=importdata('./Data/List_parameters.txt');
Lx=List_parameters(1);
N_FFT_x=round(List_parameters(2));
K_FFT_x=round(List_parameters(3));
K_FFT=round(List_parameters(6));
epsilon=List_parameters(7);
N=round(List_parameters(8));
Mmax=round(List_parameters(9));

u0_Fourier=importdata('./Data/u0_Fourier_re.txt')+1i*importdata('./Data/u0_Fourier_im.txt');

U_Fourier_1=importdata('./Data/Int1_re.txt')+1i*importdata('./Data/Int1_im.txt');
U_Fourier_2=importdata('./Data/Int2_re.txt')+1i*importdata('./Data/Int2_im.txt');
U_Fourier_1G=importdata('./Data/Int1G_re.txt')+1i*importdata('./Data/Int1G_im.txt');
U_Fourier_2G=importdata('./Data/Int2G_re.txt')+1i*importdata('./Data/Int2G_im.txt');

%% L2 and H1 norm

s1=size(U_Fourier_1);
l1=s1(2);
s2=size(U_Fourier_2);
l2=s2(2);
% s1G=size(U_Fourier_1G);
% l1G=s1G(2);
s2G=size(U_Fourier_2G);
l2G=s2G(2);

U_norm1_L2=zeros(l1,1);
U_norm2_L2=zeros(l2,1);
% U_norm1G_L2=zeros(l1G,1);
U_norm2G_L2=zeros(l2G,1);
U_norm1_H1=zeros(l1,1);
U_norm2_H1=zeros(l2,1);
% U_norm1G_H1=zeros(l1G,1);
U_norm2G_H1=zeros(l2G,1);

norm_ref_L2=norm(u0_Fourier);
norm_ref_Du0=norm(Fourier_coefficient_derivative(u0_Fourier,N_FFT_x,K_FFT_x));

for m=1:l1
    U_norm1_L2(m)=norm(U_Fourier_1(:,m))-norm_ref_L2;
    U_norm1_H1(m)=norm(Fourier_coefficient_derivative(U_Fourier_1(:,m),N_FFT_x,K_FFT_x))+U_norm1_L2(m)-norm_ref_Du0;
end
for m=1:l2
    U_norm2_L2(m)=norm(U_Fourier_2(:,m))-norm_ref_L2;
    U_norm2_H1(m)=norm(Fourier_coefficient_derivative(U_Fourier_2(:,m),N_FFT_x,K_FFT_x))+U_norm2_L2(m)-norm_ref_Du0;
end
% for m=1:l1G
%     U_norm1G_L2(m)=norm(U_Fourier_1G(:,m))-norm_ref_L2;
%     U_norm1G_H1(m)=norm(Fourier_coefficient_derivative(U_Fourier_1G(:,m),N_FFT_x,K_FFT_x))+U_norm1G_L2(m)-norm_ref_Du0;
% end
for m=1:l2G
    U_norm2G_L2(m)=norm(U_Fourier_2G(:,m))-norm_ref_L2;
    U_norm2G_H1(m)=norm(Fourier_coefficient_derivative(U_Fourier_2G(:,m),N_FFT_x,K_FFT_x))+U_norm2G_L2(m)-norm_ref_Du0;
end

t=epsilon*N*(0:Mmax)';

figure()
hold on
grid on
box on
o=plot(epsilon*N*(0:l1-1)',U_norm1_L2,'-','LineWidth',2);
o.Color=[0.8500,0.3250,0.0980];
o=plot(epsilon*N*(0:l2-1)',U_norm2_L2,'-.','LineWidth',2);
o.Color=[0.9290,0.6940,0.1250];
% plot(epsilon*N*(0:l1G-1)',U_norm1G_L2,'LineWidth',2);
o=plot(epsilon*N*(0:l2G-1)',U_norm2G_L2,'--','LineWidth',2);
o.Color=[0.4940,0.1840,0.5560];
axis([0 epsilon*N*Mmax -0.002 0.01])
hold off
xlabel('$t$');
ylabel('$L^2$ norm');
legend({'Euler method','Method A','Method B'},'Location','northeast');

figure()
hold on
grid on
box on
o=plot(epsilon*N*(0:l1-1)',U_norm1_H1,'-','LineWidth',2);
o.Color=[0.8500,0.3250,0.0980];
o=plot(epsilon*N*(0:l2-1)',U_norm2_H1,'-.','LineWidth',2);
o.Color=[0.9290,0.6940,0.1250];
% plot(epsilon*N*(0:l1G-1)',U_norm1G_H1,'LineWidth',2);
o=plot(epsilon*N*(0:l2G-1)',U_norm2G_H1,'--','LineWidth',2);
o.Color=[0.4940,0.1840,0.5560];
axis([0 epsilon*N*Mmax 0 2.5])
hold off
xlabel('$t$');
ylabel('$H^1$ norm');
legend({'Euler method','Method A','Method B'},'Location','northwest');

%% Grid evaluation

J=300;
xj=Lx/J*(-J:J)';

U_num1=zeros(2*J+1,Mmax+1);
U_num2=zeros(2*J+1,Mmax+1);
% U_num1G=zeros(2*J+1,Mmax+1);
U_num2G=zeros(2*J+1,Mmax+1);
U_der_num1=zeros(2*J+1,Mmax+1);
U_der_num2=zeros(2*J+1,Mmax+1);
% U_der_num1G=zeros(2*J+1,Mmax+1);
U_der_num2G=zeros(2*J+1,Mmax+1);
for m=1:Mmax+1
%     U_num1(:,m)=Grid_evaluation(U_Fourier_1(:,m),J,N_FFT_x,xj);
%     U_num2(:,m)=Grid_evaluation(U_Fourier_2(:,m),J,N_FFT_x,xj);
%    U_num1G(:,m)=Grid_evaluation(U_Fourier_1G(:,m),J,N_FFT_x,xj);
    U_num2G(:,m)=Grid_evaluation(U_Fourier_2G(:,m),J,N_FFT_x,xj);
    
%     U_der_num1(:,m)=Grid_evaluation_derivative(U_Fourier_1(:,m),J,N_FFT_x,xj);
%     U_der_num2(:,m)=Grid_evaluation_derivative(U_Fourier_2(:,m),J,N_FFT_x,xj);
%    U_der_num1G(:,m)=Grid_evaluation_derivative(U_Fourier_1G(:,m),J,N_FFT_x,xj);
    U_der_num2G(:,m)=Grid_evaluation_derivative(U_Fourier_2G(:,m),J,N_FFT_x,xj);
end

%% Surface plot

[X,Y]=meshgrid(xj,epsilon*N*(0:Mmax));

figure()
surf(X,Y,real(U_num2G)')
colormap(gray)
xlim([-Lx,Lx])
ylim([0 epsilon*N*Mmax])
zlim([-1.5,1.5])
xlabel('x','FontSize',16);
ylabel('t','FontSize',16);
zlabel('$Re(u)$','FontSize',16);

figure()
surf(X,Y,imag(U_num2G)')
colormap(gray)
xlim([-Lx,Lx])
ylim([0 epsilon*N*Mmax])
zlim([-1.5,1.5])
xlabel('x','FontSize',16);
ylabel('t','FontSize',16);
zlabel('$Im(u)$','FontSize',16);

figure()
surf(X,Y,real(U_der_num2G)')
colormap(gray)
xlim([-Lx,Lx])
ylim([0 epsilon*N*Mmax])
zlim([-5,5])
xlabel('x','FontSize',16);
ylabel('t','FontSize',16);
zlabel('$Re(u'')$','FontSize',16);

figure()
surf(X,Y,imag(U_der_num2G)')
colormap(gray)
xlim([-Lx,Lx])
ylim([0 epsilon*N*Mmax])
zlim([-5,5])
xlabel('x','FontSize',16);
ylabel('t','FontSize',16);
zlabel('$Im(u'')$','FontSize',16);

%% Sample plot

steps=[1 61 121 151];
alphatab=[[0,0.4470,0.7410,0.9];[0,0.4470,0.7410,0.725];[0,0.4470,0.7410,0.55];[0,0.4470,0.7410,0.375]];
av_times=epsilon*N*(steps-1);

figure()
hold on
grid on
box on
for z=1:length(steps)
    o=plot(xj,abs(round(U_num2G(:,steps(z)),15)),'LineWidth',1.5);
    o.Color=alphatab(z,:);
    %plot(xj,imag(round(U_num2G(:,steps(z)),15)),'LineWidth',1.5);
end
axis([-Lx Lx 0 1.3])
xlabel('$x$');
ylabel('$|u|$');
legend({'$t=0$','$t=6$','$t=12$','$t=15$'},'Location','northwest');

figure()
hold on
grid on
box on
for z=1:length(steps)
    o=plot(xj,abs(round(U_der_num2G(:,steps(z)),15)),'LineWidth',1.5);
    o.Color=alphatab(z,:);
    %plot(xj,imag(round(U_der_num2G(:,steps(z)),15)),'LineWidth',1.5);
end
axis([-Lx Lx 0 10])
xlabel('$x$');
ylabel('$|\partial_x u|$');
legend({'$t=0$','$t=6$','$t=12$','$t=15$'},'Location','northwest');

