%% Intro

close all; clear;
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

format long

%% Reading data

epsilon=1.0e-3;
Nmax=2^8;
LN=divisors(Nmax);
N_data=4;

U_num=importdata('./Data/data_num.txt');
N_proc=size(U_num,1)/N_data;

data_method_1=zeros(N_proc,length(LN));
data_method_2=zeros(N_proc,length(LN));
data_method_1G=zeros(N_proc,length(LN));
data_method_2G=zeros(N_proc,length(LN));
for i=0:N_proc-1
    data_method_1(i+1,:)=U_num(N_data*i+1,:);
    data_method_2(i+1,:)=U_num(N_data*i+2,:);
    data_method_1G(i+1,:)=U_num(N_data*i+3,:);
    data_method_2G(i+1,:)=U_num(N_data*i+4,:);
end

Ephiu_method_1=zeros(length(LN),1);
Ephiu_method_2=zeros(length(LN),1);
Ephiu_method_1G=zeros(length(LN),1);
Ephiu_method_2G=zeros(length(LN),1);
Err1=zeros(length(LN),1);
Err2=zeros(length(LN),1);
Err1G=zeros(length(LN),1);
Err2G=zeros(length(LN),1);
for j=1:length(LN)
    Ephiu_method_1(j)=mean(data_method_1(:,j));
    Ephiu_method_2(j)=mean(data_method_2(:,j));
    Ephiu_method_1G(j)=mean(data_method_1G(:,j));
    Ephiu_method_2G(j)=mean(data_method_2G(:,j));
end
data_exact=Ephiu_method_2G(1);
% data_exact=mean(U_exa);
for j=1:length(LN)
    Err1(j)=abs(data_exact-Ephiu_method_1(j));
    Err2(j)=abs(data_exact-Ephiu_method_2(j));
    Err1G(j)=abs(data_exact-Ephiu_method_1G(j));
    Err2G(j)=abs(data_exact-Ephiu_method_2G(j));
end

%% Plot

H=epsilon*LN;

hold on

box on

plot(H,Err1,'-*','Color',[0.8500,0.3250,0.0980],'LineWidth',1.5,'MarkerSize',8)
plot(H,Err2,'-*','Color',[0.9290,0.6940,0.1250],'LineWidth',1.5,'MarkerSize',8)
% plot(H,Err1G,'-*','LineWidth',1.5)
plot(H,Err2G,'-*','Color',[0.4940,0.1840,0.5560],'LineWidth',1.5,'MarkerSize',8)

plot(H,H/1.5,'--k','LineWidth',1.5)
plot(H,H.^2,'-.k','LineWidth',1.5)

axis([min(2*H) max(H) 2e-7 1e-1])
set(gca, 'XScale', 'log')
set(gca, 'YScale', 'log')
grid on
hold off
xlabel('$H$');
ylabel('Weak error');
legend({'Euler method','Method A','Method B','Slope 1','Slope 2'},'Location','southeast');





