%% Intro

close all; clear;
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

format long

%% Reading data

T=20;
% liste_N = floor(2.^(5:1/2:10))*T;
liste_N = floor(2.^(5:1/2:9))*T;
liste_h = T./liste_N;

U_num=importdata('./Data/data.txt');
N_proc=size(U_num,1)/2;

integral_ergodic=zeros(2,length(liste_N));
for i=1:N_proc
    integral_ergodic(1,:)=integral_ergodic(1,:)+U_num(2*i-1,:);
    integral_ergodic(2,:)=integral_ergodic(2,:)+U_num(2*i,:);
end

% exact_integral=0.019999999707289537;
exact_integral=0.8722300941804432;
num_error=abs(integral_ergodic/N_proc-exact_integral);

%% Standard error of mean

SD=zeros(2,length(liste_N));
for i=1:N_proc
    SD(1,:)=SD(1,:)+(U_num(2*i-1,:)-integral_ergodic(1,:)/N_proc).^2;
    SD(2,:)=SD(2,:)+(U_num(2*i,:)-integral_ergodic(1,:)/N_proc).^2;
end

SD=(SD/(N_proc*(N_proc-1))).^(1/2);

%% Plot

figure()

hold on
box on

h1 = errorbar(liste_h,num_error(1,:),SD(1,:),'-*','Color',[0.8500,0.3250,0.0980],'LineWidth',1.5,'MarkerSize',8);
h2 = errorbar(liste_h,num_error(2,:),SD(2,:),'-*','Color',[0.9290,0.6940,0.1250],'LineWidth',1.5,'MarkerSize',8);

ylim manual
h2.LData = h2.YData - max(eps,h2.YData-h2.LData);

plot(liste_h,liste_h,'--k','LineWidth',1.5)
plot(liste_h,10*liste_h.^2,'-.k','LineWidth',1.5)

% axis([min(liste_h) max(liste_h) 1e-7 3e-2])
axis([min(liste_h) max(liste_h) 1e-6 3e-2])
set(gca, 'XScale', 'log', 'YScale','log')
grid off
hold off
xlabel('Stepsize $h$');
ylabel('Invariant measure error');
legend({'Euler int.','Order 2 int.','Slope 1','Slope 2'},'Location','southeast');
