%% Intro

close all; clear;
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

format long

%% Reading data

T=10;
liste_N = floor(2.^(6:1:10))*T;
liste_h = T./liste_N;
liste_eps=[0.0001;0.001;0.01;0.1;1.0;10.0];
lh=length(liste_h);
leps=length(liste_eps);

S_num=importdata('./Data/data.txt');

N_proc=size(S_num,1)/(3*leps+1);

Xexa=zeros(leps,1);
Xnum_UA=zeros(leps,lh);
Xnum_EEE=zeros(leps,lh);
Xnum_EE_Manifold=zeros(1,lh);
for i=1:N_proc
    Xexa=Xexa+S_num((3*leps+1)*(i-1)+1:(3*leps+1)*(i-1)+leps,1);
    Xnum_UA=Xnum_UA+S_num((3*leps+1)*(i-1)+leps+1:(3*leps+1)*(i-1)+2*leps,:);
    Xnum_EEE=Xnum_EEE+S_num((3*leps+1)*(i-1)+2*leps+1:(3*leps+1)*(i-1)+3*leps,:);
    Xnum_EE_Manifold=Xnum_EE_Manifold+S_num((3*leps+1)*i,:);
end
Xexa=Xexa/N_proc;
Xnum_UA=Xnum_UA/N_proc;
Xnum_EEE=Xnum_EEE/N_proc;
Xnum_EE_Manifold=Xnum_EE_Manifold/N_proc;

Err_UA=abs(Xnum_UA-Xexa*ones(1,lh));
Err_EEE=abs(Xnum_EEE-Xexa*ones(1,lh));
Err_EE_Manifold=abs(ones(leps,1)*Xnum_EE_Manifold-Xexa*ones(1,lh));
%% Plot

figure()

hold on
box on

markerslist=['-o';'-h';'-s';'-*';'-d'];

for i=1:lh
    o=plot(liste_eps,Err_UA(:,i),markerslist(i,:),'Color',[0,0.4470,0.7410],'LineWidth',1.5,'MarkerSize',8);
end
axis([min(liste_eps) max(liste_eps) 2e-4 1e-1])
set(gca, 'XScale', 'log', 'YScale','log')
grid off
hold off
xlabel('Parameter $\varepsilon$');
ylabel('Invariant measure error');
legend({'$h=T/2^6$','$h=T/2^7$','$h=T/2^8$','$h=T/2^9$','$h=T/2^{10}$'},'Location','southwest','NumColumns',3);




figure()

hold on
box on

i=4;
plot(liste_eps,Err_UA(:,i),'-*','Color',[0, 0.4470, 0.7410],'LineWidth',1.5,'MarkerSize',8);
plot(liste_eps,Err_EEE(:,i),'-*','Color',[0.8500,0.3250,0.0980],'LineWidth',1.5,'MarkerSize',8);
plot(liste_eps,Err_EE_Manifold(:,i),'-*','Color',[0.9290,0.6940,0.1250],'LineWidth',1.5,'MarkerSize',8);

axis([min(liste_eps) max(liste_eps) 3e-4 1e-1])
set(gca, 'XScale', 'log', 'YScale','log')
grid off
hold off
xlabel('Parameter $\varepsilon$');
ylabel('Invariant measure error');
legend({'New method','Explicit Euler','Constrained Euler'},'Location','southeast');

